/// 阅读 api.d.ts 查看文档
///<reference path="api.d.ts"/>

import * as path from 'path';
import { UglifyPlugin, CompilePlugin, ManifestPlugin, ZipPlugin,ResSplitPlugin,ExmlPlugin, ConvertResConfigFilePlugin,EmitResConfigFilePlugin, TextureMergerPlugin, CleanPlugin } from 'built-in';
import { WxgamePlugin } from './wxgame/wxgame';
import { CustomPlugin } from './myplugin';
import * as defaultConfig from './config';

const config: ResourceManagerConfig = {

    buildConfig: (params) => {

        const { target, command, projectName, version } = params;
        const outputDir = `../${projectName}_wxgame`;
        if (command == 'build') {
            return {
                outputDir,
                commands: [
                    new CleanPlugin({ matchers: ["js", "resource"] }),
                    new CompilePlugin({ libraryType: "debug", defines: { DEBUG: true, RELEASE: false } }),
                    new ExmlPlugin('commonjs'), // 非 EUI 项目关闭此设置
                    new WxgamePlugin(),
                    new ResSplitPlugin({
                        verbose: false, matchers:
                        [
                            { from: "resource/art/about/**.**", to: `${projectName}_wxgame_remote` },
                            { from: "resource/art/heros_goods/**.**", to: `${projectName}_wxgame_remote` }
                        ]
                    }),
                    // new UglifyPlugin([
                    //     {
                    //         sources: [
                    //             "libs/modules/egret/egret.js",
                    //             "libs/modules/eui/eui.js",
                    //             "libs/modules/assetsmanager/assetsmanager.js",
                    //             "libs/modules/tween/tween.js",
                    //         ],
                    //         target: "lib.min.js"
                    //     }
                    // ]),
                    // new ZipPlugin({
                    //     mergeSelector: p => {
                    //         // 如果文件是assets/路径下的， 压缩到resource下的assets.zip
                    //         if (p.indexOf("assets/") >= 0) {
                    //             return "resource/assets.zip"
                    //         }else{
                    //             return ''
                    //         }
                    //     }
                    // }),
                    // new TextureMergerPlugin({textureMergerRoot:[ 'resource']}),
                    // new ConvertResConfigFilePlugin({
                    //     resourceConfigFiles: [{ filename: "resource/default.res.json", root: "resource/" }],
                    //     nameSelector: (p) => {
                    //          return path.basename(p).split(".").join("_")
                    //     },
                    //     TM_Verbose: true
                    // }),
                    new ManifestPlugin({ output: 'manifest.js' })
                ]
            }
        }
        else if (command == 'publish') {
            return {
                outputDir,
                commands: [
                    new CleanPlugin({ matchers: ["js", "resource"] }),
                    new CompilePlugin({ libraryType: "release", defines: { DEBUG: false, RELEASE: true } }),
                    new ExmlPlugin('commonjs'), // 非 EUI 项目关闭此设置
                    new WxgamePlugin(),
                    new UglifyPlugin([{
                        sources: ["main.js"],
                        target: "main.min.js"
                    }
                    ]),
                    new ManifestPlugin({ output: 'manifest.js' })
                ]
            }
        }
        else {
            throw `unknown command : ${params.command}`;
        }
    },

    mergeSelector: defaultConfig.mergeSelector,

    typeSelector: defaultConfig.typeSelector
}



export = config;
