class KTXTextureProcessorCustom implements RES.processor.Processor {

    private USE_KZIP: Boolean = true;

    onLoadStart(host, resource) {
        egret.log('ddd')
        var func1 = (data) => {
            egret.log('func1')
            if (!data) {
                console.error('ktx:' + resource.root + resource.url + ' is null');
                return null;
            }
            const ktx = new egret.KTXContainer(data, 1);
            if (ktx.isInvalid) {
                console.error('ktx:' + resource.root + resource.url + ' is invalid');
                return null;
            }
            const bitmapData = new egret.BitmapData(data);
            bitmapData.debugCompressedTextureURL = resource.root + resource.url;
            bitmapData.format = 'ktx';
            ktx.uploadLevels(bitmapData, false);
            //
            const texture = new egret.Texture();
            texture._setBitmapData(<egret.BitmapData>bitmapData);
            const r = host.resourceConfig.getResource(resource.name);
            if (r && r.scale9grid) {
                const list: Array<string> = r.scale9grid.split(",");
                texture["scale9Grid"] = new egret.Rectangle(parseInt(list[0]), parseInt(list[1]), parseInt(list[2]), parseInt(list[3]));
            }
            //
            host.save(resource, texture);
            return texture;
        }

        var func2 = function (e) {
            host.remove(resource);
            throw e;
        }

        if (this.USE_KZIP) {
            //加载zip
            var newResource = {
                name: resource.name.replace(".ktx", '.ktx.zip'),
                url: resource.url.replace(".ktx", '.ktx.zip'),
                type: 'bin',
                root: resource.root,
                etc1_alpha_url: resource.etc1_alpha_url,
            }
            // egret.log('res',JSON.stringify(newResource))
            return host.load(newResource, 'bin').then(fileData => {
                return JSZip.loadAsync(fileData);
            }).then(object => {
                let arr = resource.url.split('/')
                let realUrl = arr[arr.length-1]
                // realUrl = resource.name.replace('.ktx','');
                egret.log('realUrl',realUrl)
                let jsZipObject = object.file(realUrl);
                return jsZipObject.async("arraybuffer")
            }).then(func1, func2);
        }
        else {
            return host.load(resource, 'bin').then(func1, func2);
        }

    }

    onRemoveStart(host, resource) {
        const texture = host.get(resource);
        if (texture) {
            texture.dispose();
        }
    }
}


