/** JSZip的实例表示一组文件。您可以添加、删除、修改它们。您还可以导入一个现有的zip文件或生成一个。 */
declare class JSZip {
    /** 实例化一个JSZip实例 */
    public constructor();
    /** zip文件内的所有文件名称 */
    public files: Object;
    /** zip文件的注释 */
    public comment: string;
    /** 根目录 */
    public root: string;
    /**
     * 获取具有指定名称的文件。可以在名称中指定文件夹:文件夹分隔符是正斜杠(“/”)。
     * @param name 文件名称
     */
    public file(name: string): ZipObject;
    /**
     * 使用正则表达式在当前文件夹和子文件夹中搜索文件。
     * @param regex 正则表达式
     */
    public file(regex: RegExp): ZipObject[];
    /**
     * 向zip文件添加(或更新)一个文件。如果出现错误(例如，数据的格式不受支持)，则在访问数据时将抛出异常。
     * @param name 文件名称
     * @param data 文件数据
     * @param option 选项
     */
    public file(name: string, data: string | ArrayBuffer | Uint8Array | Blob, option?: {
        /** 如果数据是base64编码的，则设置为true。例如，<canvas>元素中的图像数据。纯文本和HTML不需要这个选项。默认false。 */
        base64?: boolean,
        /** 如果数据应该作为原始内容处理，则设置为true;如果是文本，则设置为false。如果使用base64，默认为true，如果数据不是字符串，则设置为true。默认false。 */
        binary?: boolean,
        /** 最后修改日期。默认值为当前日期。 */
        date?: Date,
        /** 如果设置，指定要用于此特定文件的压缩方法。如果没有，将使用默认文件压缩，请参见generateAsync(选项)。默认null。 */
        compression?: string,
        /** 压缩文件时要使用的选项，请参阅generateAsync(选项)。默认null。 */
        compressionOptions?: Object,
        /** 对这个文件的注释。默认null。 */
        comment?: string,
        /** 如果(且仅当)输入是一个“二进制字符串”并且已经用0xFF掩码进行了准备，则设置为true。默认false。 */
        optimizedBinaryString?: boolean,
        /** 如果文件路径中的文件夹应该自动创建，则设置为true，否则将只存在表示文件路径的虚拟文件夹。默认true。 */
        createFolders?: boolean,
        /** 文件的UNIX权限(如果有的话)。默认null。 */
        unixPermissions?: number,
        /** 文件的DOS权限(如果有的话)。默认null。 */
        dosPermissions?: number,
        /** 如果这是一个目录且内容应该被忽略，则将其设置为true。默认fasle。 */
        dir?: boolean
    });
    /**
     * 创建指定名称的目录，返回一个新的JSZip对象，新文件夹作为根目录。
     * @param name 目录名称
     */
    public folder(name: string): JSZip;
    /**
     * 使用正则表达式在当前目录中搜索子目录。对正则表达式进行相对路径测试。
     * @param regex 正则表达式
     */
    public folder(regex: RegExp): ZipObject[];
    /**
     * 在此文件夹级别为每个条目调用回调函数。
     * @param callback 回调函数。relativePath：文件名及其相对于当前文件夹的路径。file：当前文件。
     */
    public forEach(callback: (relativePath: string, file: ZipObject) => void): void;
    /**
     * 用指定的函数过滤嵌套的文件/文件夹。
     * @param predicate 判断函数，如果包含文件，必须返回true，否则返回false。relativePath：文件名及其相对于当前文件夹的路径。file：正在测试的文件。
     */
    public filter(predicate: (relativePath: string, file: ZipObject) => void): ZipObject[];
    /**
     * 删除一个文件或文件夹(递归地)。
     * @param name 文件或目录名称
     */
    public remove(name: string): JSZip;
    /**
     * 在当前文件夹级别生成完整的zip文件。
     * @param options 选项
     * @param onUpdate 可选函数在每个内部更新时调用元数据。percent：完成的百分比(在0到100之间)。currentFile：正在处理的当前文件的名称(如果有的话)。
     */
    public generateAsync(options: {
        /** 要返回的zip类型，请参阅下面的其他类型。必需的。可能的值：base64、binarystring、array、uint8array、arraybuffer、blob、nodebuffer。 */
        type: string,
        /** 要使用的默认文件压缩方法。默认“STORE”。“STORE”-不压缩，“DEFLATE”-压缩。 */
        compression?: string,
        /** 压缩文件时要使用的选项。默认null。 */
        compressionOptions?: {
            /** 压缩等级1~9 */
            level: number
        },
        /** 用于zip文件的注释。 */
        comment?: string,
        /** 生成的文件的mime类型。默认“application/zip”。 */
        mimeType?: string,
        /** 生成zip文件时使用的平台。默认“DOS”。 */
        platform?: string,
        /** 对文件名/注释进行编码的函数。默认使用UTF-8编码。 */
        encodeFileName?: (str: string) => Uint8Array | Array<number>

    }, onUpdate?: (percent: number, currentFile: string) => void): Promise<any>;
    /**
     * 生成zip文件的选项，请参阅generateAsync()的选项
     * @param options 选项
     */
    public generateInternalStream(options: {
        /** 要返回的zip类型，请参阅下面的其他类型。必需的。可能的值：base64、binarystring、array、uint8array、arraybuffer、blob、nodebuffer。 */
        type: string,
        /** 要使用的默认文件压缩方法。默认“STORE”。“STORE”-不压缩，“DEFLATE”-压缩。 */
        compression?: string,
        /** 压缩文件时要使用的选项。默认null。 */
        compressionOptions?: {
            /** 压缩等级1~9 */
            level: number
        },
        /** 用于zip文件的注释。 */
        comment?: string,
        /** 生成的文件的mime类型。默认“application/zip”。 */
        mimeType?: string,
        /** 生成zip文件时使用的平台。默认“DOS”。 */
        platform?: string,
        /** 对文件名/注释进行编码的函数。默认使用UTF-8编码。 */
        encodeFileName?: (str: string) => Uint8Array | Array<number>

    }): StreamHelper;
    /**
     * 读取现有zip文件并在当前文件夹级别合并当前JSZip对象中的数据。这种技术有一些局限性，请看这里。如果JSZip对象已经包含条目，那么将合并新的条目。如果两个名称相同，加载的一个将替换另一个。
     * @param data zip文件
     * @param options 选项
     */
    public loadAsync(data: string | Array<number> | ArrayBuffer | Uint8Array | Blob, options?: {
        /** 如果数据是base64编码的，则设置为true，对于二进制则为false。 */
        base64?: boolean,
        /** 如果应该根据CRC32检查读数据，则设置为true。 */
        checkCRC32?: boolean,
        /** 如果(且仅当)输入是字符串并且已经用0xFF掩码准备好了，则设置为true。 */
        optimizedBinaryString?: boolean,
        /** 设置为true将自动在文件路径中创建文件夹。保留为false将只创建虚拟文件夹(即只表示文件路径的一部分的文件夹)。 */
        createFolders?: boolean,
        /** 解码文件名/注释的函数。默认使用UTF-8解码。 */
        decodeFileName?: (bytes: Uint8Array | Array<number>) => string
    }): Promise<JSZip>;
    /**
     * 静态函数方式加载zip文件
     * @param data zip文件
     * @param options 选项
     */
    public static loadAsync(data: string | Array<number> | ArrayBuffer | Uint8Array | Blob, options?: {
        /** 如果数据是base64编码的，则设置为true，对于二进制则为false。 */
        base64?: boolean,
        /** 如果应该根据CRC32检查读数据，则设置为true。 */
        checkCRC32?: boolean,
        /** 如果(且仅当)输入是字符串并且已经用0xFF掩码准备好了，则设置为true。 */
        optimizedBinaryString?: boolean,
        /** 设置为true将自动在文件路径中创建文件夹。保留为false将只创建虚拟文件夹(即只表示文件路径的一部分的文件夹)。 */
        createFolders?: boolean,
        /** 解码文件名/注释的函数。默认使用UTF-8解码。 */
        decodeFileName?: (bytes: Uint8Array | Array<number>) => string
    }): Promise<JSZip>;
    /** 如果浏览器支持它们，JSZip可以利用一些“新”特性:ArrayBuffer、Blob、Uint8Array。要知道JSZip是否可以使用它们，可以检查JSZip。支持对象。 */
    public static support: {
        /** 如果JSZip可以读取和生成arraybuffer，为真，否则为假。 */
        arraybuffer: boolean,
        /** 如果JSZip可以读取和生成uint8array，为真，否则为假。 */
        uint8array: boolean,
        /** 如果JSZip可以生成blob，则为true，否则为false。 */
        blob: boolean,
        /** 如果JSZip可以读取和生成nodejs缓冲区，为真，否则为假。 */
        nodebuffer: boolean,
        /** 真，如果JSZip可以读取和生成nodejs流，否则false。 */
        nodestream: boolean
    };
    /** JSZip使用的对象可能不存在于每个平台上，在这种情况下，它使用垫片。访问或替换这些对象有时很有用。全局对象在可用时优先使用。 */
    public static external: {
        /** 所使用的Promise实现。 */
        Promise: any
    };
    /** 版本 */
    public static version: string;
}
/** 这表示zip文件中的一个条目。如果条目来自先前加载的现有存档，那么内容将首先被自动解压缩/转换。 */
declare class ZipObject {
    /** 文件的绝对路径 */
    public name: string;
    /** 如果这是一个目录，则为true */
    public dir: string;
    /** 如果这是最近的修改日期，则为true */
    public date: Date;
    /** 对这个文件的注释 */
    public comment: string;
    /** 文件的UNIX权限(如果有的话)。 */
    public unixPermissions: number;
    /** 文件的DOS权限(如果有的话)。 */
    public dosPermissions: number;
    /** 文件的选项。 */
    public options: {
        /** 如果数据是base64编码的，则设置为true。例如，<canvas>元素中的图像数据。纯文本和HTML不需要这个选项。默认false。 */
        base64?: boolean,
        /** 如果数据应该作为原始内容处理，则设置为true;如果是文本，则设置为false。如果使用base64，默认为true，如果数据不是字符串，则设置为true。默认false。 */
        binary?: boolean,
        /** 最后修改日期。默认值为当前日期。 */
        date?: Date,
        /** 如果设置，指定要用于此特定文件的压缩方法。如果没有，将使用默认文件压缩，请参见generateAsync(选项)。默认null。 */
        compression?: string,
        /** 压缩文件时要使用的选项，请参阅generateAsync(选项)。默认null。 */
        compressionOptions?: Object,
        /** 对这个文件的注释。默认null。 */
        comment?: string,
        /** 如果(且仅当)输入是一个“二进制字符串”并且已经用0xFF掩码进行了准备，则设置为true。默认false。 */
        optimizedBinaryString?: boolean,
        /** 如果文件路径中的文件夹应该自动创建，则设置为true，否则将只存在表示文件路径的虚拟文件夹。默认true。 */
        createFolders?: boolean,
        /** 文件的UNIX权限(如果有的话)。默认null。 */
        unixPermissions?: number,
        /** 文件的DOS权限(如果有的话)。默认null。 */
        dosPermissions?: number,
        /** 如果这是一个目录且内容应该被忽略，则将其设置为true。默认fasle。 */
        dir?: boolean
    };
    /**
     * 返回请求类型中内容的Promise。
     * @param type 结果的类型。可能值：base64、text (或者 string)、binarystring、array、uint8array、arraybuffer、blob、nodebuffer。
     * @param onUpdate 在每个内部更新中调用一个可选的元数据函数。
     */
    public async(type: string, onUpdate?: (metadata: {
        /** 完成的百分比(在0到100之间) */
        percent: number
    }) => void): Promise<any>;
    /**
     * 返回请求类型中的内容的StreamHelper。
     * @param type 结果的类型:string, binarystring, uint8array, arraybuffer, nodebuffer。
     */
    public internalStream(type: string): StreamHelper;
}
/** 可以将StreamHelper看作具有一些helper方法的可暂停流。它不像nodejs中那样是一个功能完整的流(不能直接作为一个使用)，但是公开的方法应该足以与其他异步库一起编写粘合代码:on('data'， function)， on('end'， function)和on('error'， function)。它开始暂停，请确保准备好后恢复()。如果您正在寻找一个不需要编写胶水代码的异步帮助程序，那么请查看collections(函数)。 */
declare class StreamHelper {
    /**
     * 注册事件
     * @param event 事件的名称。只支持3个事件:data（function (data, metadata){}）、end（function (){}）、error（function (e){}）。
     * @param callback 事件发生时调用的函数。
     */
    public on(event: string, callback: Function): StreamHelper;
    /**
     * 读取整个流并使用完整的内容调用回调。
     * @param updateCallback 每次流更新时调用的函数。这个函数是可选的。
     */
    public accumulate(updateCallback?: ({
        percent: number,
        currentFile: string
    }) => void): StreamHelper;
    /** 如果流正在运行，则暂停流。一旦暂停，流停止发送数据事件。 */
    public pause(): StreamHelper;
}
