//////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014-present, Egret Technology.
//  All rights reserved.
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Egret nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY EGRET AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL EGRET AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////////////

class Main extends egret.DisplayObjectContainer {



    public constructor() {
        super();
        this.addEventListener(egret.Event.ADDED_TO_STAGE, this.onAddToStage, this);
    }

    private onAddToStage(event: egret.Event) {

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin

            context.onUpdate = () => {

            }
        })

        egret.lifecycle.onPause = () => {
            egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            egret.ticker.resume();
        }

        this.runGame().catch(e => {
            console.log(e);
        })



    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        const result = await RES.getResAsync("description_json")
        this.startAnimation(result);

    }

    private async loadResource() {
        try {
            const loadingView = new LoadingUI();
            this.stage.addChild(loadingView);
            await RES.loadConfig("resource/default.res.json", "resource/");
            await RES.loadGroup("preload", 0, loadingView);
            this.stage.removeChild(loadingView);
        }
        catch (e) {
            console.error(e);
        }
    }

    private textfield: egret.TextField;

    /**
     * 创建游戏场景
     * Create a game scene
     */
    private createGameScene() {
        let sky = this.createBitmapByName("bg_jpg");
        this.addChild(sky);
        let stageW = this.stage.stageWidth;
        let stageH = this.stage.stageHeight;
        sky.width = stageW;
        sky.height = stageH;

        let topMask = new egret.Shape();
        topMask.graphics.beginFill(0x000000, 0.5);
        topMask.graphics.drawRect(0, 0, stageW, 172);
        topMask.graphics.endFill();
        topMask.y = 33;
        this.addChild(topMask);

        let icon = this.createBitmapByName("egret_icon_png");
        this.addChild(icon);
        icon.x = 26;
        icon.y = 33;

        let line = new egret.Shape();
        line.graphics.lineStyle(2, 0xffffff);
        line.graphics.moveTo(0, 0);
        line.graphics.lineTo(0, 117);
        line.graphics.endFill();
        line.x = 172;
        line.y = 61;
        this.addChild(line);


        let colorLabel = new egret.TextField();
        colorLabel.textColor = 0xffffff;
        colorLabel.width = stageW - 172;
        colorLabel.textAlign = "center";
        colorLabel.text = "Hello Egret";
        colorLabel.size = 24;
        colorLabel.x = 172;
        colorLabel.y = 80;
        this.addChild(colorLabel);

        let textfield = new egret.TextField();
        this.addChild(textfield);
        textfield.alpha = 0;
        textfield.width = stageW - 172;
        textfield.textAlign = egret.HorizontalAlign.CENTER;
        textfield.size = 24;
        textfield.textColor = 0xffffff;
        textfield.x = 172;
        textfield.y = 135;
        this.textfield = textfield;


        // let sd = RES.getRes("se1_mp3")
        // let sd2= RES.getRes("se1_mp3")
        // console.log('sd1',sd)
        // console.log('sd2',sd2)
        // if(sd == sd2){
        //     console.log('same')
        // }else{
        //     console.log('not sae')
        // }
        


        for (let i = 0; i < 3; i++) {
            // let sd =  RES.getRes("se1_mp3")
            let sd = new egret.Sound()
            // let sd = RES.getResByUrl('resource/assets/se1.mp3')
            sd.load('resource/assets/se1.mp3')

            let eff = new Sound_Effect('坦克' + (i + 1),sd, true);
            eff.x = stageW / 2;
            eff.y = stageH / 2 + i * 70;
            this.addChild(eff)
        }
        // console.log(1111)
        // console.log(egret.registerClass)
        // let str = egret.registerClass.toString()
        // console.log('egret.registerClass:',str.slice(0,100))

    }

    /**
     * 根据name关键字创建一个Bitmap对象。name属性请参考resources/resource.json配置文件的内容。
     * Create a Bitmap object according to name keyword.As for the property of name please refer to the configuration file of resources/resource.json.
     */
    private createBitmapByName(name: string) {
        let result = new egret.Bitmap();
        let texture: egret.Texture = RES.getRes(name);
        result.texture = texture;
        return result;
    }

    /**
     * 描述文件加载成功，开始播放动画
     * Description file loading is successful, start to play the animation
     */
    private startAnimation(result: string[]) {
        let parser = new egret.HtmlTextParser();

        let textflowArr = result.map(text => parser.parse(text));
        let textfield = this.textfield;
        let count = -1;
        let change = () => {
            count++;
            if (count >= textflowArr.length) {
                count = 0;
            }
            let textFlow = textflowArr[count];

            // 切换描述内容
            // Switch to described content
            textfield.textFlow = textFlow;
            let tw = egret.Tween.get(textfield);
            tw.to({ "alpha": 1 }, 200);
            tw.wait(2000);
            tw.to({ "alpha": 0 }, 200);
            tw.call(change, this);
        };

        change();
    }
}
class Sound_Effect extends egret.DisplayObjectContainer {
    private bg: egret.Sprite;
    private isPlay: boolean
    private channel: egret.SoundChannel;
    private sound: any;
    private times: number;
    constructor(name: string, sound: any, loop: boolean) {
        super();
        this.sound = sound;
        console.log(777,name,sound)
        this.times = loop ? 0 : 1;
        let bg = new egret.Sprite();
        this.bg = bg;
        bg.touchEnabled = true;
        this.addChild(bg)

        let txt = new egret.TextField();
        txt.size = 20;
        txt.text = name;
        txt.width = 80;
        txt.height = 40;
        txt.verticalAlign = egret.VerticalAlign.MIDDLE;
        txt.textAlign = egret.HorizontalAlign.CENTER;

        this.addChild(txt);

        this.isPlay = false;
        this.changeState();

        this.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if (this.isPlay) {
                this.stop();
            } else {
                this.play();
            }
            this.isPlay = !this.isPlay;
            this.changeState();
        }, this)

    }
    private changeState(): void {
        let color = this.isPlay ? 0x279be9 : 0x3ab4ef
        this.bg.graphics.clear();
        this.bg.graphics.beginFill(color);
        this.bg.graphics.drawRect(0, 0, 80, 40);
        this.bg.graphics.endFill();
    }
    private play(): void {
        this.channel = this.sound.play(0, this.times);
        this.channel.addEventListener(egret.Event.SOUND_COMPLETE, this.onComplete, this)
    }
    private stop(): void {
        if (this.channel) {
            this.channel.removeEventListener(egret.Event.SOUND_COMPLETE, this.onComplete, this)
            this.channel.stop();
            this.channel = null;
        }
    }
    private onComplete(): void {
        if (this.times > 0) {
            this.isPlay = false;
            this.changeState();
        }
    }
}
