class Util {
     /**灰色 */
    static COLOR_GRAY = 0x7d7d7d
    /**白色 */
    static COLOR_WHITE = 0xFFFFFF
    /**黑色 */
    static COLOR_BLACK = 0x00000
    /**绿色 */
    static COLOR_GREEN = 0x00ff00
    /**蓝色 */
    static COLOR_BLUE = 0x00ffff
    /**紫色 */
    static COLOR_PURPLE = 0xff00ff
    /**橙色 */
    static COLOR_ORANGE = 0xffa500
    /**红色 */
    static COLOR_RED = 0xff0000;
    /**黄色 */
    static COLOR_YELLOW = 0xfff206;
    /**粉色 */
    static COLOR_PINK = 0xEFA5DB;
    
     /** 16进制转rgb值 */
    public static HexToColor(color: number): { r: number, g: number, b: number } {
        let result = { r: -1, g: -1, b: -1 };
        result.b = color % 256;
        result.g = Math.floor((color / 256)) % 256;
        result.r = Math.floor((color / 256) / 256);
        return result;
    }

    /** 设置图片颜色 */
    public static setImageColor(image: eui.Image, color: number) {

        // if (egret.Capabilities.runtimeType == egret.RuntimeType.WXGAME)
        //     return;

        let result = Util.HexToColor(color);
        let colorMatrix = [
            1, 0, 0, 0, 0,
            0, 1, 0, 0, 0,
            0, 0, 1, 0, 0,
            0, 0, 0, 1, 0
        ];
        colorMatrix[0] = result.r / 255;
        colorMatrix[6] = result.g / 255;
        colorMatrix[12] = result.b / 255;
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        image.filters = [colorFilter];
    }


}
