//////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014-present, Egret Technology.
//  All rights reserved.
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Egret nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY EGRET AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL EGRET AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////////////

class Main extends eui.UILayer {


    protected createChildren(): void {
        super.createChildren();
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })
        egret.lifecycle.onPause = () => {
            egret.ticker.pause();
        }
        egret.lifecycle.onResume = () => {
            egret.ticker.resume();
        }
        //inject the custom material parser
        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());
        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();

    }

    private async loadResource() {
        try {
            //除了 icon 这个图片，其他全部忽略掉
            const ignoreResource = (imageResourceInfo: RES.ResourceInfo): boolean => {
                if(imageResourceInfo.name =='1_png'){
                    egret.log('use ktx',imageResourceInfo.name)
                    return false;
                }else{
                    egret.log('use png',imageResourceInfo.name)
                    return true;
                }
                
            };


            let resourceRoot = "resource/";
            await RES.loadConfig("default.res.json", resourceRoot);

            RES.processor.map('image', new CompressTextureProcessor(ignoreResource, false));
            await RES.loadConfig("default.res.json", resourceRoot);
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        
        let ct = new egret.Sprite();
        this.addChild(ct);

        let btn3 = new egret.TextField();
        btn3.text = "LoadPng";
        btn3.x = 300;
        btn3.y = 100;
        btn3.touchEnabled =true;
        this.addChild(btn3);
        btn3.addEventListener(egret.TouchEvent.TOUCH_TAP, ()=>{
            for(let  i =0; i < 20; i++){
                let mapimage = new eui.Image();
                // mapimage.source = i+"_png";
                mapimage.source = "0_png";
                mapimage.x = i * 5;
                ct.addChild(mapimage);
            }
        }, this);

        let btn4 = new egret.TextField();
        btn4.text = "RemovePng";
        btn4.x = 300;
        btn4.y = 200;
        btn4.touchEnabled =true;
        this.addChild(btn4);
        btn4.addEventListener(egret.TouchEvent.TOUCH_TAP, ()=>{
            ct.removeChildren();
            RES.destroyRes('0_png')
        }, this);

        let btn5 = new egret.TextField();
        btn5.text = "LoadKtx";
        btn5.x = 300;
        btn5.y = 300;
        btn5.touchEnabled =true;
        this.addChild(btn5);
        btn5.addEventListener(egret.TouchEvent.TOUCH_TAP, ()=>{
            for(let  i =0; i < 20; i++){
                let mapimage = new eui.Image();
                // mapimage.source = i+"_png";
                mapimage.source = "1_png";
                mapimage.x = i * 5;
                ct.addChild(mapimage);
            }
        }, this);

        let btn6 = new egret.TextField();
        btn6.text = "RemoveKtx";
        btn6.x = 300;
        btn6.y = 400;
        btn6.touchEnabled =true;
        this.addChild(btn6);
        btn6.addEventListener(egret.TouchEvent.TOUCH_TAP, ()=>{
            ct.removeChildren();
            RES.destroyRes('1_png')
        }, this);



        
    }

}
