
/**
 * 自定义ETC1KTXProcessor，方便添加日志查找问题
 */
class ETC1KTXProcessorCustom implements RES.processor.Processor {

    onLoadStart(host, resource): Promise<any> {
        return host.load(resource, "ktx").then((colorTex) => {
            if (!colorTex) {
                return null;
            }
            if (resource['etc1_alpha_url']) {
                const r = makeEtc1SeperatedAlphaResourceInfo(resource);
                return host.load(r, "ktx")
                    .then((alphaMaskTex) => {
                        if (colorTex && colorTex.$bitmapData && alphaMaskTex.$bitmapData) {
                            colorTex.$bitmapData.etcAlphaMask = alphaMaskTex.$bitmapData;
                            host.save(r, alphaMaskTex);
                        }
                        else {
                            host.remove(r);
                        }
                        return colorTex;
                    }, function (e) {
                        host.remove(r);
                        throw e;
                    });
            }
            return colorTex;
        }, function (e) {
            host.remove(resource);
            throw e;
        });
    }

    onRemoveStart(host, resource) {
        const colorTex = host.get(resource);
        if (colorTex) {
            colorTex.dispose();
        }
        if (resource['etc1_alpha_url']) {
            const r = makeEtc1SeperatedAlphaResourceInfo(resource);
            const alphaMaskTex = host.get(r!);
            if (alphaMaskTex) {
                alphaMaskTex.dispose();
            }
            //host.unload(r);//这里其实还会再删除一次，不过无所谓了。alphaMaskTex已经显示删除了
        }
    }
}

function makeEtc1SeperatedAlphaResourceInfo(resource) {
    return { name: resource.name + '_alpha', url: resource['etc1_alpha_url'], type: 'ktx', root: resource.root };
}


RES.processor.map("etc1.ktx", new ETC1KTXProcessorCustom());
