//////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014-present, Egret Technology.
//  All rights reserved.
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Egret nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY EGRET AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL EGRET AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////////////
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
/**
 * 将ImageProcessor, KTXTextureProcessor, ETC1KTXProcessor做整合
 */
var CompressTextureProcessor = (function () {
    /**
     * constructor
     */
    function CompressTextureProcessor(ignoreResource, usePackEtc1Ktx) {
        this.usePackEtc1Ktx = false;
        this.ignoreResource = ignoreResource;
        this.usePackEtc1Ktx = usePackEtc1Ktx;
    }
    /**
     * 路径后缀替换成.ktx
     */
    CompressTextureProcessor.prototype.convertURL = function (url, replace) {
        var fileSuffix = CompressTextureProcessor.fileSuffix;
        for (var _i = 0, fileSuffix_1 = fileSuffix; _i < fileSuffix_1.length; _i++) {
            var fx = fileSuffix_1[_i];
            if (url.indexOf(fx) !== -1) {
                return url.replace(fx, replace);
            }
        }
        return url;
    };
    /**
     * 转化资源
     */
    CompressTextureProcessor.prototype.createCompressTextureResourceInfo = function (imageResourceInfo) {
        //
        if (this.ignoreResource && this.ignoreResource(imageResourceInfo)) {
            return imageResourceInfo;
        }
        egret.log('使用ktx资源', imageResourceInfo.name);
        //
        var supportedCompressedTexture = egret.Capabilities.supportedCompressedTexture;
        if (supportedCompressedTexture.pvrtc) {
            var convertURL = this.convertURL(imageResourceInfo.url, '.pvr.ktx');
            //创造临时的新资源
            return {
                name: convertURL,
                url: convertURL,
                type: 'pvrtc.ktx',
                root: imageResourceInfo.root
            };
        }
        else if (supportedCompressedTexture.etc1) {
            var convertURL = this.convertURL(imageResourceInfo.url, '.ktx');
            //创造临时的新资源
            var resInfo = {
                name: convertURL,
                url: convertURL,
                type: 'etc1.ktx',
                root: imageResourceInfo.root
            };
            //
            if (this.usePackEtc1Ktx) {
                resInfo.url = this.convertURL(imageResourceInfo.url, '.pack.etc1.ktx');
                resInfo.type = 'pack.etc1.ktx';
            }
            //.jpg 出来的默认是没有独立alpha
            if (imageResourceInfo.url.indexOf('.png') !== -1) {
                resInfo['etc1_alpha_url'] = this.convertURL(imageResourceInfo.url, '_alpha.ktx');
            }
            return resInfo;
        }
        return imageResourceInfo;
    };
    /**
     * 转化资源
     */
    CompressTextureProcessor.prototype.onLoadStart = function (host, resource) {
        var resInfo = this.createCompressTextureResourceInfo(resource);
        if (resInfo.type === 'pvrtc.ktx' || resInfo.type === 'etc1.ktx' || resInfo.type === 'pack.etc1.ktx') {
            return host.load(resInfo, resInfo.type);
        }
        return host.load(resource, RES.processor.ImageProcessor);
    };
    /**
     * 转化资源
     */
    CompressTextureProcessor.prototype.onRemoveStart = function (host, resource) {
        var resInfo = this.createCompressTextureResourceInfo(resource);
        if (resInfo.type === 'pvrtc.ktx' || resInfo.type === 'etc1.ktx' || resInfo.type === 'pack.etc1.ktx') {
            return host.unload(resInfo);
        }
        var texture = host.get(resource);
        if (texture) {
            egret.log('CompressTextureProcessor: onRemoveStart = ' + resource.name);
            texture.dispose();
        }
        else {
            egret.warn('CompressTextureProcessor: onRemoveStart lose resource = ' + resource.name);
        }
    };
    /**
     * 替换的文件后缀名
     */
    CompressTextureProcessor.fileSuffix = ['.png', '.jpg', 'jpeg'];
    return CompressTextureProcessor;
}());
__reflect(CompressTextureProcessor.prototype, "CompressTextureProcessor", ["RES.processor.Processor"]);
