//////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014-present, Egret Technology.
//  All rights reserved.
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Egret nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY EGRET AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL EGRET AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////////////

class Main extends egret.DisplayObjectContainer {



    public constructor() {
        super();
        this.addEventListener(egret.Event.ADDED_TO_STAGE, this.onAddToStage, this);
    }

    private onAddToStage(event: egret.Event) {

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin

            context.onUpdate = () => {

            }
        })

        egret.lifecycle.onPause = () => {
            egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            egret.ticker.resume();
        }

        this.runGame().catch(e => {
            console.log(e);
        })



    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        const result = await RES.getResAsync("description_json")
        this.startAnimation(result);
        await platform.login();
        const userInfo = await platform.getUserInfo();
        console.log(userInfo);

    }

    private async loadResource() {
        try {
            const loadingView = new LoadingUI();
            this.stage.addChild(loadingView);

            const ignoreResource = (info: RES.ResourceInfo): boolean => {
                return info && info.name != 'test_png';
            }
            RES.processor.map('image', new CompressTextureProcessor(ignoreResource, false));

            await RES.loadConfig("resource/default.res.json", "resource/");
            await RES.loadGroup("preload", 0, loadingView);
            this.stage.removeChild(loadingView);
        }
        catch (e) {
            console.error(e);
        }
    }

    private textfield: egret.TextField;

    /**
     * 创建游戏场景
     * Create a game scene
     */
    private createGameScene() {
        let sky = this.createBitmapByName("bg_jpg");
        this.addChild(sky);
        let stageW = this.stage.stageWidth;
        let stageH = this.stage.stageHeight;
        sky.width = stageW;
        sky.height = stageH;

        let topMask = new egret.Shape();
        topMask.graphics.beginFill(0x000000, 0.5);
        topMask.graphics.drawRect(0, 0, stageW, 172);
        topMask.graphics.endFill();
        topMask.y = 33;
        this.addChild(topMask);

        let icon = this.createBitmapByName("egret_icon_png");
        this.addChild(icon);
        icon.x = 26;
        icon.y = 33;

        let line = new egret.Shape();
        line.graphics.lineStyle(2, 0xffffff);
        line.graphics.moveTo(0, 0);
        line.graphics.lineTo(0, 117);
        line.graphics.endFill();
        line.x = 172;
        line.y = 61;
        this.addChild(line);


        let colorLabel = new egret.TextField();
        colorLabel.textColor = 0xffffff;
        colorLabel.textAlign = "center";
        colorLabel.text = "Hello Egret";
        colorLabel.size = 24;
        colorLabel.width = stageW - 172;
        colorLabel.x = 172;
        colorLabel.y = 80;

        let textfield = new egret.TextField();
        this.addChild(textfield);
        textfield.alpha = 0;
        textfield.width = stageW - 172;
        textfield.textAlign = egret.HorizontalAlign.CENTER;
        textfield.size = 24;
        textfield.textColor = 0xffffff;
        textfield.x = 172;
        textfield.y = 135;
        this.textfield = textfield;

        let ktx = this.createBitmapByName('test_png');
        ktx.x = 10;
        ktx.y = 120;
        this.addChild(ktx);
        
        let textureKtx: egret.Texture = RES.getRes('test_png');
        let bitmapDataKtx = textureKtx.bitmapData;
        bitmapDataKtx.$deleteSource = false;

        let texturePng: egret.Texture = RES.getRes('test_png_png');
        let bitmapDataPng = texturePng.bitmapData;
        bitmapDataPng.$deleteSource = false;

        let webGLCtx = egret.sys.customHitTestBuffer.context;
        let gl = webGLCtx.context;
        let self = this;
        let ktxCount = 0;
        let pngCount = 0;

        this.addChild(colorLabel);

        let btn0 = new egret.TextField();
        btn0.background = true;
        btn0.backgroundColor = 0xff0000;
        btn0.textColor = 0xffffff;
        btn0.text = '性能测试';
        btn0.x = 10;
        btn0.y = 600;
        this.addChild(btn0);
        btn0.touchEnabled = true;
        btn0.addEventListener(egret.TouchEvent.TOUCH_TAP, function() {
            if (ktx.parent) {
                self.removeChild(ktx);
            }
            let count = 100;
            let t0 = performance.now();
            for (let i = 0; i < count; i++) {
                bitmapDataKtx.webGLTexture = null;
                webGLCtx.getWebGLTexture(bitmapDataKtx);
            }
            let t1 = performance.now();
            for (let i = 0; i < count; i++) {
                bitmapDataPng.webGLTexture = null;
                webGLCtx.getWebGLTexture(bitmapDataPng);
            }
            let t2 = performance.now();
            let texImage2DFunc = gl.texImage2D;
            let compressedTexImage2DFunc = gl.compressedTexImage2D;
            gl.texImage2D = function(){};
            gl.compressedTexImage2D = function(){};
            let t3 = performance.now();
            for (let i = 0; i < count; i++) {
                bitmapDataKtx.webGLTexture = null;
                webGLCtx.getWebGLTexture(bitmapDataKtx);
            }
            let t4 = performance.now();
            for (let i = 0; i < count; i++) {
                bitmapDataPng.webGLTexture = null;
                webGLCtx.getWebGLTexture(bitmapDataPng);
            }
            let t5 = performance.now();
            gl.texImage2D = texImage2DFunc;
            gl.compressedTexImage2D = compressedTexImage2DFunc;
            colorLabel.x = 0;
            colorLabel.width = stageW;
            colorLabel.background = true;
            colorLabel.backgroundColor = 0x222222;
            colorLabel.text = '正常提交纹理:\n' +
                    '提交压缩纹理 ' + count + ' 次耗时 ' + (t1 - t0).toFixed(2) + ' ms\n' +
                    '提交png纹理 ' + count + ' 次耗时 ' + (t2 - t1).toFixed(2) + ' ms\n' +
                    '不执行提交纹理的gl方法:\n' +
                    '提交压缩纹理 ' + count + ' 次耗时 ' + (t4 - t3).toFixed(2) + ' ms\n' +
                    '提交png纹理 ' + count + ' 次耗时 ' + (t5 - t4).toFixed(2) + ' ms';

            ktxCount += count;
            pngCount += count;
        }, this);

        let btn1 = new egret.TextField();
        btn1.background = true;
        btn1.backgroundColor = 0xff0000;
        btn1.textColor = 0xffffff;
        btn1.text = '提交100张ktx';
        btn1.x = 10;
        btn1.y = 700;
        this.addChild(btn1);
        btn1.touchEnabled = true;
        btn1.addEventListener(egret.TouchEvent.TOUCH_TAP, function() {
            if (ktx.parent) {
                self.removeChild(ktx);
            }
            let count = 1000;
            for (let i = 0; i < count; i++) {
                bitmapDataKtx.webGLTexture = null;
                webGLCtx.getWebGLTexture(bitmapDataKtx);
            }
            ktxCount += count;
            colorLabel.text = '已提交ktx纹理:' + ktxCount;
        }, this);

        let btn2 = new egret.TextField();
        btn2.background = true;
        btn2.backgroundColor = 0xff0000;
        btn2.textColor = 0xffffff;
        btn2.text = '提交100张png';
        btn2.x = 10;
        btn2.y = 800;
        this.addChild(btn2);
        btn2.touchEnabled = true;
        btn2.addEventListener(egret.TouchEvent.TOUCH_TAP, function() {
            if (ktx.parent) {
                self.removeChild(ktx);
            }
            let count = 1000;
            for (let i = 0; i < count; i++) {
                bitmapDataPng.webGLTexture = null;
                webGLCtx.getWebGLTexture(bitmapDataPng);
            }
            pngCount += count;
            colorLabel.text = '已提交png纹理:' + pngCount;
        }, this);

        let btn3 = new egret.TextField();
        btn3.background = true;
        btn3.backgroundColor = 0xff0000;
        btn3.textColor = 0xffffff;
        btn3.text = '下载100组ktx color + alpha纹理';
        btn3.x = 10;
        btn3.y = 900;
        this.addChild(btn3);
        btn3.touchEnabled = true;
        btn3.addEventListener(egret.TouchEvent.TOUCH_TAP, function() {
            if (ktx.parent) {
                self.removeChild(ktx);
            }
            let t0 = performance.now();
            let dnCount = 0;
            for (let i = 1; i <= 100; i++) {
                RES.getResByUrl('http://10.0.6.238/test/a/test_' + i + '.ktx', function() {
                    dnCount++;
                    if (dnCount == 200) {
                        let t1 = performance.now();
                        colorLabel.text = '下载100组ktx color + alpha纹理耗时:' + (t1 - t0).toFixed(2) + 'ms';
                    }
                }, this, 'bin');
                RES.getResByUrl('http://10.0.6.238/test/a/test_alpha_' + i + '.ktx', function() {
                    dnCount++;
                    if (dnCount == 200) {
                        let t1 = performance.now();
                        colorLabel.text = '下载100组ktx color + alpha纹理耗时:' + (t1 - t0).toFixed(2) + 'ms';
                    }
                }, this, 'bin');
            }
        }, this);

        let btn4 = new egret.TextField();
        btn4.background = true;
        btn4.backgroundColor = 0xff0000;
        btn4.textColor = 0xffffff;
        btn4.text = '下载100张ktx pack纹理';
        btn4.x = 10;
        btn4.y = 1000;
        this.addChild(btn4);
        btn4.touchEnabled = true;
        btn4.addEventListener(egret.TouchEvent.TOUCH_TAP, function() {
            if (ktx.parent) {
                self.removeChild(ktx);
            }
            let t0 = performance.now();
            let dnCount = 0;
            for (let i = 1; i <= 100; i++) {
                RES.getResByUrl('http://10.0.6.238/test/a/test.pack.etc1_' + i + '.ktx', function() {
                    dnCount++;
                    if (dnCount == 100) {
                        let t1 = performance.now();
                        colorLabel.text = '下载100张ktx pack纹理耗时:' + (t1 - t0).toFixed(2) + 'ms';
                    }
                }, this, 'bin');
            }
        }, this);
    }

    /**
     * 根据name关键字创建一个Bitmap对象。name属性请参考resources/resource.json配置文件的内容。
     * Create a Bitmap object according to name keyword.As for the property of name please refer to the configuration file of resources/resource.json.
     */
    private createBitmapByName(name: string) {
        let result = new egret.Bitmap();
        let texture: egret.Texture = RES.getRes(name);
        result.texture = texture;
        return result;
    }

    /**
     * 描述文件加载成功，开始播放动画
     * Description file loading is successful, start to play the animation
     */
    private startAnimation(result: string[]) {
        let parser = new egret.HtmlTextParser();

        let textflowArr = result.map(text => parser.parse(text));
        let textfield = this.textfield;
        let count = -1;
        let change = () => {
            count++;
            if (count >= textflowArr.length) {
                count = 0;
            }
            let textFlow = textflowArr[count];

            // 切换描述内容
            // Switch to described content
            textfield.textFlow = textFlow;
            let tw = egret.Tween.get(textfield);
            tw.to({ "alpha": 1 }, 200);
            tw.wait(2000);
            tw.to({ "alpha": 0 }, 200);
            tw.call(change, this);
        };

        change();
    }
}