## 压缩纹理性能测试

### 工程说明

对比提交压缩纹理和普通纹理的性能。

demo中对比了同一张纹理提交100次的耗时，没有修改引擎代码，只在游戏代码中hack了引擎的一些方法。

关键代码：

```javascript
let t0 = performance.now();
for (let i = 0; i < count; i++) {
    // 将BitmapData的webGLTexture设为null可以保证下次getWebGLTexture会重新提交纹理。
    bitmapDataKtx.webGLTexture = null;
    webGLCtx.getWebGLTexture(bitmapDataKtx);
}
let t1 = performance.now();
for (let i = 0; i < count; i++) {
    bitmapDataPng.webGLTexture = null;
    webGLCtx.getWebGLTexture(bitmapDataPng);
}
let t2 = performance.now();
```

### 测试结果

时间单位：ms。微信小游戏的performance.now()和浏览器的时间单位不一致，在adapter中进行了修改。

机型|平台|提交ktx|提交png|提交ktx(不执行gl方法)|提交png(不执行gl方法)
-----------|--------|----|----|----|----
小米MIX3|系统浏览器|36.6|207.8|0.7|0.6
小米MIX3|Chrome|25.5|253.7|1.1|0.6
小米MIX3|微信小游戏|78|202|5|2
小米MIX3|runtime|9.58|943.73|1.58|1.22
iPhone6|Safari|26|374|2|2
iPhone6|微信小游戏|40|2486|5|5
iPhone6|runtime|40.12|1780.97|4.88|4.51

## 压缩纹理内存测试

建议用小内存的手机。以下内存数据没有排除显存以外因素的干扰，不表示准确的显存占用。

查看内存工具：Xcode、Android Studio的Profiler

### 工程说明

每次运行分别提交压缩纹理和普通纹理，iOS上每次提交100张纹理，Android上每次提交1000张纹理，观察浏览器/webview/runtime提交到多少张纹理时崩溃。

### 测试结果

下面的表格统计了提交多少张纹理后开始出现错误：崩溃（iOS）或闪烁（Android），值越大表示可提交的纹理数量越多。

单位：张

机型|平台|崩溃时提交ktx数量|崩溃时提交png数量|500张ktx内存占用|500张png内存占用
-----------|--------|----|----|----|----
iPhone6|WKWebView|10000以上|1100|未知|未知
iPhone6|Safari|10000以上|1400|未知|未知

机型|平台|闪烁时提交ktx数量|闪烁时提交png数量|3000张ktx内存占用|3000张png内存占用
-----------|--------|----|----|----|----
华为P8|WebView|7000|3000|380M|1G
华为P8|系统浏览器|24000|5000|未知|未知

## 下载速度测试

### 工程说明

对比下载100组etc1 ktx纹理的color纹理加alpha纹理，和100张合并了color和alpha的etc1 ktx纹理的速度。

### 测试结果

为了尽量减少网络抖动的影响，测试环境为局域网环境。

单位：ms

机型|平台|color纹理加alpha纹理|合并后的纹理
-----------|--------|----|----
小米MIX3|系统浏览器|6064.3|4270.3
小米MIX3|runtime|6155.49|5705.27
小米MIX3|微信小游戏|10840|9720
华为P8|系统浏览器|21127.5|11255.4
华为P8|runtime|23319.28|14471.03
华为P8|微信小游戏|60460|28110
